{$i-,s-,g+,r-}
{$ifndef modif}{$i modif.inc}{$endif}
Program GraphicsCompare;
uses {$ifdef Windows}
     WinCrtx,WinDos,
     {$else}
       {$ifdef crtx}crtx,{$else}crt,{$endif}dos,
     {$endif}
     pictures,toolsb;

var a:string;
    fbr,obr:Picture;
    difimage:string;
    i:integer;
    MarkedTime:Longint;
    diff:real;
    PassLProc:PercentLineProc;

Function GetInterval:Longint; assembler;
asm
	MOV	AH,0
        INT	1Ah
        MOV	AX,DX
        MOV	DX,CX
end;


Label 1,10,20;


const Title:array[0..17]of char='Compare Graphics'#0;
const Verbosity:integer = 0;
const HeaderPrinted:integer = 0;

Procedure PrintHeader;
begin
  if((Verbosity>=0) and (HeaderPrinted<=0)) then
    begin
    writeln(#10#13'<<< GComp >>> Compare two graphical images (c)1997-2009 F&TSoft');
    HeaderPrinted:=1;
    end
end;



begin
difimage:='';
{$ifdef Windows}
ScreenSize.X:=62;
ScreenSize.Y:=10;
WindMax:=ScreenSize;
Move(Title,WindowTitle,Sizeof(Title));
{$endif}

PassLProc.Init;
obr.init;
fbr.init;
{$ifndef  Windows}
  DirectVideo:=False;
  nosound;
  {$endif}
diff:=0;
if Paramcount=0 then
	begin
	PrintHeader;
1:	write('Enter name of 1''st picture:');readln(a);
	if a='' then goto 1;
	assignpicture(obr,a);
	write('Enter name of 2''nd picture:');readln(a);
	assignpicture(fbr,a);
	end;

for i:=1 to paramcount do
	begin
	a:=paramStr(i);
	if((a[2]='?')or(a[1]='?'))or((UpCases(a)='/HELP')or(UpCases(a)='-HELP')) then
	  begin
	  writeln(#10#13'GCOMP file1 file2 [/gray] '#10#13+
		        'Supported input file formats are ART,BMP,CUT,FTG,GIF,HRZ,ICO,'+
		        {$ifdef jpg}'JPG,'+{$endif}
		        'MAT,OKO,PBM,PCX,PS,RAS,TIF,TGA,TXT,WPG'+
		        #10#13);
	  {$ifdef Windows}InactiveWinCrt;{$endif}
	  exit;
	end;

	if UpCases(a)='/S' then
	  begin
	  Verbosity:=-1;
	  continue;
	  end;
        
	if a[1]='/' then
	    begin
	    a:='/dif';
	    inc(i);
	    difimage:=paramStr(i);
	    end
	    else if obr.filename=nil then assignpicture(obr,a)
				     else assignpicture(fbr,a);
	end;

PrintHeader;

if obr.filename=nil then
	begin
	writeln('Error:Unknown filename of 1''st image!');
	{$ifdef Windows}InactiveWinCrt;{$endif}
	halt(1);
	end;
if obr.filename=nil then
	begin
	writeln('Error:Unknown filename of 2''nd image!');
	{$ifdef Windows}InactiveWinCrt;{$endif}
	halt(2);
	end;

 if Verbosity>0 then
   begin
   write(#13'Loading 1''st ');ClrEol;
   loadpicture(obr,'',@PassLProc)
   end
 else
   loadpicture(obr,'',nil);

if obr.data=nil then
	begin
	writeln(#10#13'Cannot find 1''st image:''',obr.filename^,'''');
	{$ifdef Windows}InactiveWinCrt;{$endif}
	halt(3);
	end;

 if Verbosity>0 then
   begin  
   write(#13'Loading 2''nd ');ClrEol;
   loadpicture(fbr,'',@PassLProc);
   end
 else
   loadpicture(fbr,'',nil);

if fbr.data=nil then
	begin
	writeln(#10#13'Cannot find 2''nd image:''',fbr.filename^,'''');
	{$ifdef Windows}InactiveWinCrt;{$endif}
	halt(4);
	end;

markedTime:=GetInterval;
if Verbosity>0 then
  begin
  write(#13'Comparing ');ClrEol;
  diff:=Compare(Obr,fbr,@PassLProc);
  end
else
  diff:=Compare(Obr,fbr,nil);

if(difimage<>'') then
   begin
   Operation2(Obr,Fbr,SubbS,nil,nil);
   savepicture(Obr,difimage,@PassLProc);
   end;

write(#13);
if diff=0 then 
  begin
  if Verbosity>0 then
     writeln('Both images have same contents.')
  end
else
  if diff<0 then writeln('Error occured during compare! ',abs(diff):2:0)
            else writeln('Found ',abs(diff):2:0,' mismatches! ');

fbr.Done;
obr.Done;

{$ifdef Windows}InactiveWinCrt;{$endif}
if diff<>0 then halt(5);
halt(0);
end.
